import computed from 'ember-computed';
import Component from 'ember-component';
import injectService from 'ember-service/inject';
import { CHEER_PREFIX } from 'web-client/utilities/bits/constants-config';

export default Component.extend({
  classNames: ['js-bits-undo-prompt'],
  bitsRoom: injectService(),

  amount: computed.readOnly('bitsRoom.delayedBitsSendAmount'),
  channelName: computed.readOnly('bitsRoom.channelDisplayName'),

  prefix: computed('bitsRoom.prefix', 'bitsRoom.isSamePrefix', function () {
    return this.get('bitsRoom.isSamePrefix') ? this.get('bitsRoom.prefix') : CHEER_PREFIX;
  }),

  actions: {
    send() {
      this.get('bitsRoom').forceSendMessage();
    },
    cancel() {
      this.get('bitsRoom').cancelDelayedSend();
    }
  }

});
