import Component from 'ember-component';
import computed from 'ember-computed';
import injectService from 'ember-service/inject';
import { BITS_URL } from 'web-client/utilities/urls/static-cdn';

export const AD_ERROR_TYPES = {
  EXIT_EARLY: 'exitEarly',
  UNKNOWN: 'unknown',
  ADBLOCK: 'adblock',
  LIMIT_REACHED: 'limitReached'
};

export default Component.extend({
  classNames: ['js-bits-watch-ad-error'],
  bitsRoom: injectService(),

  errorType: computed.readOnly('bitsRoom.adsForBitsErrorType'),
  exitedEarly: computed.equal('errorType', AD_ERROR_TYPES.EXIT_EARLY),
  unknownError: computed.equal('errorType', AD_ERROR_TYPES.UNKNOWN),
  hasAdblock: computed.equal('errorType', AD_ERROR_TYPES.ADBLOCK),
  limitReached: computed.equal('errorType', AD_ERROR_TYPES.LIMIT_REACHED),

  imageUrl: computed('exitedEarly', 'unknownError', 'hasAdblock', 'limitReached', function () {
    let imageName;

    if (this.get('hasAdblock')) {
      imageName = 'adserroradblock';
    } else if (this.get('limitReached')) {
      imageName = 'adserrorlimit';
    } else {
      imageName = 'adserrorgeneric';
    }

    return `${BITS_URL}/light/static/1/${imageName}.png`;
  }),

  errorHeaderKey: computed('exitedEarly', 'unknownError', 'hasAdblock', 'limitReached', function () {
    let errorHeaderKey;

    if (this.get('limitReached')) {
      errorHeaderKey = 'ads_error_header_limit_reached';
    } else {
      errorHeaderKey = 'ads_error_header';
    }

    return errorHeaderKey;
  }),

  errorDescKey: computed('exitedEarly', 'unknownError', 'hasAdblock', 'limitReached', function () {
    let errorDescKey;

    if (this.get('exitedEarly')) {
      errorDescKey = 'ads_error_exited_early';
    } else if (this.get('unknownError')) {
      errorDescKey = 'ads_error_unknown';
    } else if (this.get('hasAdblock')) {
      errorDescKey = 'ads_error_adblock';
    } else if (this.get('limitReached')) {
      errorDescKey = 'ads_error_limit_reached';
    }

    return errorDescKey;
  }),

  actions: {
    close() {
      this.get('bitsRoom').dismissTooltip();
    },
    tryAgain() {
      this.get('bitsRoom').hideAdError();
    },
    buyBits() {
      this.get('buyBits')();
    }
  }
});
