import computed from 'ember-computed';
import Component from 'ember-tether/components/ember-tether';
import injectService from 'ember-service/inject';
import observer from 'ember-metal/observer';
import on from 'ember-evented/on';

export default Component.extend({
  layout: injectService(),
  storage: injectService(),
  hideHotspot: computed.readOnly('layout.isTheatreMode'),

  // ember tether props
  target: computed.readOnly('tetherId'),
  targetAttachment: 'top right',
  attachment: 'top left',
  classNames: ['z--mountain'],

  offset: computed('layout.isLeftColumnClosed', function() {
    if (this.get('layout.isLeftColumnClosed')) {
      return '-10px 8px';
    }
    return '-8px 8px';
  }),

  onLeftColumnToggle: on('init', observer('layout.isLeftColumnAnimating', function() {
    if (!this.get('layout.isLeftColumnAnimating')) {
      this.rerender();
    }
  })),

  actions: {
    dismiss() {
      this.set('storage.userLearnedMoreAboutBrowseExperiment', true);
    }
  }
});
