import computed from 'ember-computed';
import injectService from 'ember-service/inject';
import Component from 'ember-component';
import observer from 'ember-metal/observer';
import on from 'ember-evented/on';

export default Component.extend({
  browse: injectService(),
  layout: injectService(),
  navigation: injectService(),

  isBrowseExperimentSubmenuEnabled: computed.readOnly('browse.isBrowseExperimentSubmenuEnabled'),

  showTooltip: false,

  classNames: 'balloon-wrapper warp__item js-left-nav-item',
  tagName: 'dd',

  onLeftColumnToggle: on('init', observer('layout.isLeftColumnAnimating', function() {
    if (!this.get('layout.isLeftColumnAnimating')) {
      this.rerender();
    }
  })),

  tetherId: computed('elementId', function(){
    return `#${this.get('elementId')}`;
  }),

  actions: {
    toggleSubmenu() {
      this.toggleProperty('showTooltip');
    }
  }
});
