import computed from 'ember-computed';
import Component from 'ember-tether/components/ember-tether';
import injectService from 'ember-service/inject';
import observer from 'ember-metal/observer';
import ClickOutsideMixin from 'web-client/mixins/click-outside';
import on from 'ember-evented/on';

export default Component.extend(ClickOutsideMixin, {
  layout: injectService(),

  classNames: 'balloon balloon--dropmenu balloon--no-tail balloon--right be-balloon js-left-nav-submenu',

  // ember tether props
  target: computed.readOnly('tetherId'),
  targetAttachment: 'top right',
  attachment: 'top left',
  offset: '0 6px',

  // Inside ClickOutsideMixin `addEventListener` executes our clickedOutside
  // callback immediately, so we use `wasAutoRun` to ignore that first execution.
  wasAutoRun: true,

  clickedOutside() {
    if (!this.get('wasAutoRun')) {
      this._close();
    }

    this.set('wasAutoRun', false);
  },

  _close() {
    this.set('parentView.showTooltip', false);
  },

  onLeftColumnToggle: on('init', observer('layout.isLeftColumnAnimating', function() {
    if (!this.get('layout.isLeftColumnAnimating')) {
      this.rerender();
    }
  })),

  click() {
    this._close();
  }
});
