import Component from 'ember-component';
import computed from 'ember-computed';

import { PREVIEWS_TTV_URL } from 'web-client/utilities/urls/static-cdn';

let ChannelPreview = Component.extend({
  tagName: 'img',
  attributeBindings: ['src'],

  src: computed('name', function() {
    let name = encodeURI(this.get('name'));
    return `${ PREVIEWS_TTV_URL }/live_user_${ name }-320x180.jpg`;
  })
});

ChannelPreview.reopenClass({
  positionalParams: ['name']
});

export default ChannelPreview;
