import Component from 'ember-component';

export default Component.extend({
  showTooltip: false,
  copySuccess: false,
  copyError: false,
  mouseEnter() {
    this.set('showTooltip', true);
  },

  mouseLeave() {
    this.set('showTooltip', false);
    this.set('copySuccess', false);
    this.set('copyError', false);
  },

  actions: {
    copySuccess() {
      this.trackShare('link');
      this.set('copySuccess', true);
    },

    copyError() {
      this.set('copyError', true);
      this.selectCopyLink();
    }
  }
});
