import ChannelRedesignComponent from 'web-client/components/channel-redesign/component';
import computed from 'ember-computed';
import injectService from 'ember-service/inject';
import SendRouteAction from 'web-client/mixins/send-route-action';
import run from 'ember-runloop';
import { assign } from 'ember-platform';
import { bind } from 'ember-runloop';
import $ from 'jquery';
import { TOP_NAV_HEIGHT } from 'web-client/services/layout';

export default ChannelRedesignComponent.extend(SendRouteAction, {
  scrollActivity: injectService(),
  layout: injectService(),
  session: injectService(),
  globals: injectService(),
  tracking: injectService(),
  experiments: injectService(),
  persistentPlayer: injectService(),
  channel: null,

  isFoodChannel: computed.equal('channel.id', 'food'),

  init() {
    this._super(...arguments);

    let experiments = this.get('experiments');

    experiments.getExperimentValue('CPR_SUB_NAV_V2').then(value => {
      if (this.isDestroyed) { return; }

      let isSubNavExperiment = value === 'new';
      let isChannelIndex = this.get('isChannelIndex');

      this.set('isSubNavExperiment', isSubNavExperiment);

      if (isSubNavExperiment && isChannelIndex) {
        this.$videoPlayer = this.$('.js-player').height() ? this.$('.js-player') : this.$('.player-placeholder');
        this.set('videoPlayerHeight', this.$videoPlayer.height());

        this.$scrollContainer = $('#main_col .tse-scroll-content');
        this.get('scrollActivity').subscribe(this, this.$scrollContainer, bind(this, 'handleScroll'));
      }
    });

    experiments.getExperimentValue('EXTENSIONS').then(value => {
      if (this.isDestroyed) { return; }
      if (value === 'yes') {
        let channel = this.get('channel');
        channel.fetchInstalledExtensions().then(() => {
          this.set('isExtensionsEnabled', true);
        });
      }
    });
  },

  installedExtensions: computed('isExtensionsEnabled', 'channel.installedExtensions', function() {
    if (this.get('isExtensionsEnabled')) {
      return this.get('channel.installedExtensions');
    }
  }),

  isExtensionsEnabled: false,

  // noop the parent handlers, which initialize scroll behavior
  transitionHandler: null,

  didInsertElement() {
    let $placeholder = this.$('.player-placeholder');
    this.$playerPlaceholder = $placeholder.length > 0 ? $placeholder : null;

    this.updatePlayerPosition();

    if (!this.get('persistentPlayer.isFullSize') && this.get('persistentPlayer.isVisible')) {
      this.sendRouteAction('anchorPlayer', 'maximize');
    } else {
      this.sendRouteAction('showPlayer');
    }
  },

  didRender() {
    run.scheduleOnce('afterRender', this, 'updatePlayerPosition');
  },

  updatePlayerPosition() {
    if (!this.$playerPlaceholder) {
      return;
    }

    let $scrollContainer = this.$playerPlaceholder.scrollParent();
    let playerOffset = this.$playerPlaceholder.offset();
    let playerTop = playerOffset.top + $scrollContainer.scrollTop();
    let playerLeft = playerOffset.left - $scrollContainer.offset().left;

    if (this.get('layout.isSocialColumnEnabled')) {
      playerTop -= TOP_NAV_HEIGHT;
    }

    this.set('persistentPlayer.fullSizePlayerLocation', {
      top: playerTop,
      left: playerLeft
    });
  },

  handleScroll() {
    if (this.isDestroyed || this.isDestroying) { return; }

    if (this.get('videoPlayerHeight') !== this.$videoPlayer.height()) {
      this.set('videoPlayerHeight', this.$videoPlayer.height());
    }

    let scrollTopValue = this.$scrollContainer.scrollTop();
    this.set('isSmallBar', scrollTopValue < this.get('videoPlayerHeight'));
  },

  isUpsellBannerVisible: true,
  visible: true,
  targetChannel: computed.or('channel.hostModeTarget', 'channel'),
  isInMaintenanceMode: computed.readOnly('globals.isInMaintenanceMode'),

  pastBroadcasts: computed('channel.pastBroadcasts', function () {
    if (this.get('channel.pastBroadcasts') && !this.get('channel.pastBroadcasts.isLoaded')) {
      this.get('channel.pastBroadcasts').load();
    }
    return this.get('channel.pastBroadcasts');
  }),

  actions: {
    panelLinkClick(context) {
      this.get('tracking').trackEvent({
        event: 'panel_link_click',
        data: assign(context, {
          channel: this.get('channel.id'),
          channel_live: this.get('isLive'),
          login: this.get('session.userData.login')
        })
      });
    },

    openPost() {
    }
  }
});
