import computed from 'ember-computed';
import Component from 'ember-component';
import observer from 'ember-metal/observer';
import injectService from 'ember-service/inject';
import { BREAKAWAY, STREAMLINE } from 'web-client/utilities/game-names';
import { BREAKAWAY_ALPHA_LINK as bkAlphaUrl } from 'web-client/utilities/urls/fuel';

export default Component.extend({
  session: injectService(),
  globals: injectService(),
  gameSettings: injectService(),

  bkAlphaUrl,

  isBreakaway: computed.equal('channel.game', BREAKAWAY),
  isStreamline: computed.equal('channel.game', STREAMLINE),
  isFlDetailsLinkEnabled: computed.readOnly('globals.isFlDetailsLinkEnabled'),
  textShouldBeGameDetails: false,
  shouldDisplayDetailsLink: false,

  classNames: ['inline-block'],

  _watchGameUpdate: observer('channel.game', 'channel.partner', 'isStreamline', function () {
    this.debounceTask('setShouldDisplayDetailsLink', 500);
  }),

  setShouldDisplayDetailsLink () {

    if (!this.get('channel.partner') || !this.get('channel.game')) {
      this.set('shouldDisplayDetailsLink', false);
      return;
    }

    this.get('gameSettings').getGameSettings(this.get('channel.game')).then(detailsEnabled => {
      if (this.isDestroyed) { return; }
      this.set('shouldDisplayDetailsLink', detailsEnabled);
      // Design wants streamline to have a different label for now, until main launch
      this.set('textShouldBeGameDetails', this.get('isStreamline'));
    });
  },

  init () {
    this._super(...arguments);
    this.setShouldDisplayDetailsLink();
  }
});
