/* globals Twitch, i18n */

import Component from 'ember-component';
import injectService from 'ember-service/inject';
import computed from 'ember-computed';
import { CREATIVE } from 'web-client/utilities/game-names';

import { TTV_BOXART_404_URL } from 'web-client/utilities/urls/static-cdn';

export default Component.extend({
  classNames: ['metadata-box', 'qa-metadata-box'],
  session: injectService(),
  community: injectService(),

  tags:  computed('channel.status', function(){
    return this.get('community').extractFromTags(this.get('channel.status'));
  }),

  boxArt: computed('channel.game', function() {
    let game = this.get('channel.game');
    let boxart = Twitch.uri.gameBoxArtJpg(game);
    return boxart ? boxart : TTV_BOXART_404_URL;
  }),

  gameHref: computed('channel.game', function() {
    return Twitch.uri.game(this.get('channel.game'));
  }),

  isCreative: computed.equal('channel.game', CREATIVE),

  teamHref: computed('channel.primaryTeamName', function() {
    let primaryTeamName = this.get('channel.primaryTeamName');
    if (primaryTeamName) {
      return Twitch.uri.team(primaryTeamName);
    }
  }),

  // This is a (sad) workaround because `i18n-split-string` does not order multiple divs correctly for some languages.
  // On the template side, we determine which markup should be displayed first.
  teamLinkFirst: computed('isCreative', function() {
    let localized = i18n("Streaming |gameLink| on |teamLink|");
    return localized.indexOf('|teamLink|') < localized.indexOf('|gameLink|');
  })
});
