import NotificationControlsComponent from 'web-client/components/notification-controls';
import ClickOutsideMixin from 'web-client/mixins/click-outside';

// TODO:  Merge this ClickOutsideMixin in with regular notification-controls
export default NotificationControlsComponent.extend(ClickOutsideMixin, {

  // App Download URLs
  iOSAppLink: "https://itunes.apple.com/us/app/twitch/id460177396?mt=8",
  AndroidAppLink: "https://play.google.com/store/apps/details?id=tv.twitch.android.app",

  clickedOutside() {
    this.set('isMenuOpen', false);
    this.sendAction('hideOverflow');
  },

  actions: {
    toggleMenu() {
      this.sendAction('toggleOverflow');
      this.toggleProperty('isMenuOpen');
    }
  }
});
