import Component from 'ember-component';
import computed from 'ember-computed';
import { scheduleOnce } from 'ember-runloop';
import InteractivityDeferredComponent from 'web-client/mixins/interactivity-deferred-component';
import {
  PAST_BROADCASTS_TYPE,
  HIGHLIGHTS_TYPE,
  UPLOADED_VIDEOS_TYPE
} from 'web-client/mixins/video-type';

const NO_VIDEOS_MESSAGE = {
    [PAST_BROADCASTS_TYPE]: 'No Past Broadcasts Found',
    [HIGHLIGHTS_TYPE]: 'No Highlights Found',
    [UPLOADED_VIDEOS_TYPE]: 'No Uploads Found'
};

export default Component.extend(InteractivityDeferredComponent, {
  videoType: '',

  noVideosMessage: computed('videoType', function() {
    let videoType = this.get('videoType');

    let typeMessage = NO_VIDEOS_MESSAGE[videoType];
    if (typeMessage) {
      return typeMessage;
    }

    return 'No Videos Found';
  }),

  didInsertElement() {
    this._super(...arguments);
    scheduleOnce('afterRender', this, this.reportInteractive);
  }
});
