/* globals i18n */
import Component from 'ember-component';
import computed from 'ember-computed';

export default Component.extend({
  showDropdown: false,

  filterType: computed('streamType', function () {
    let type = this.get('streamType');
    switch (type) {
    case 'top':
      return i18n('All Channels');
    case 'psFour':
      return 'PlayStation 4';
    case 'xbOne':
      return 'Xbox One';
    case 'creative':
      return 'Creative';
    }
  }),

  showFilters: computed('streamType', function () {
    let type = this.get('streamType');

    return type !== 'random';
  }),

  didInsertElement() {
    this.addEventListener(this.element, 'clickoutside', () => {
      this.set('showDropdown', false);
    });
  },

  click() {
    this.toggleProperty('showDropdown');
  }
});
