import Component from 'ember-component';
import injectController from 'web-client/utilities/inject-controller';
import injectService from 'ember-service/inject';
import SendRouteActionMixin from 'web-client/mixins/send-route-action';
import computed from 'ember-computed';

export default Component.extend(SendRouteActionMixin, {
  elementId: 'right_col',
  classNameBindings: ['isRightColumnClosed:closed:open'],
  classNames: ['column', 'fixed'],

  globals: injectService(),
  layout: injectService(),
  chatSettings: injectService(),
  tracking: injectService(),
  channelController: injectController('channel'),
  isRightColumnClosed: computed.alias('layout.isRightColumnClosed'),
  isChatOpen: computed.alias('layout.isChatOpenOnProfileSidebar'),

  willDestroyElement() {
    this._super(...arguments);
    this.$('#chat_settings_dropmenu, .js-chatters-container').hide();
  },

 actions: {
    toggleChat() {
      this.toggleProperty('isChatOpen');
    },

    // Most of these actions aren't invoked directly from `chat-right-column`,
    // but rather from within ember-twitch-chat.
    handleLoginButtonClick() {
      this.sendRouteAction('handleLoginButtonClick');
    },

    handleSignupButtonClick() {
      this.sendRouteAction('handleSignupButtonClick');
    },

    openInModal() {
      this.sendRouteAction('openInModal', ...arguments);
    },

    closeModal() {
      this.sendRouteAction('closeModal', ...arguments);
    },

    handleHideAd() {
      this.$('.js-new-channel-ad .js-adhide').hide();
      this.$('.js-rightcol-content').css('top', '0px');
      this.get('tracking').trackEvent({ event: 'channel-adclose', services: ['mixpanel']});
    }
  }
});
