import Component from 'ember-component';
import injectService from 'ember-service/inject';
import SendRouteActionMixin from 'web-client/mixins/send-route-action';
import { altRolesExperiment } from 'web-client/utilities/chat-sticky';

export default Component.extend(SendRouteActionMixin, {
  classNames: ['js-alt-role-notification'],
  classNameBindings: [':sticky-message', 'alt-role-notification'],

  globals: injectService(),
  layout: injectService(),
  tracking: injectService(),
  session: injectService(),
  chatSticky: injectService(),

  notificationTitle: altRolesExperiment.title,
  notificationText: altRolesExperiment.text,

  didRender() {
    this._super(...arguments);
    this.get('tracking').trackEvent({
      event: 'see_alt_role_sticky',
      data: {
        channel: this.get('channelName'),
        login: this.get('session.userData.login'),
        url: window.location.href,
        browser: this.get('globals.browserName'),
        collapse_right: this.get('layout.isRightColumnClosed')
      }
    });
  },

  goToAltRoleChannel(url) {
    this.get('tracking').trackEvent({
      event: 'click_alt_role_sticky',
      data: {
        url: window.location.href,
        channel: this.get('channelName'),
        login: this.get('session.userData.login'),
        browser: this.get('globals.browserName'),
        destination_url: url
      }
    });
    this.sendRouteAction('handleStreamClick', { id: url });
  }

});
