/* global i18n */
import Component from 'ember-component';
import computed from 'ember-computed';

const LANG_CODE_MAPPINGS = {
  'en': 'English',
  'zh': 'Chinese',
  'zh-TW': 'Chinese',
  'zh-HK': 'Chinese',
  'ja': 'Japanese',
  'ko': 'Korean',
  'es': 'Spanish',
  'es-MX': 'Spanish (Mexico)',
  'fr': 'French',
  'de': 'German',
  'it': 'Italian',
  'pt': 'Portuguese (Portugal)',
  'pt-BR': 'Portuguese (Brazil)',
  'sv': 'Swedish',
  'no': 'Norwegian',
  'da': 'Danish',
  'nl': 'Dutch',
  'fi': 'Finnish',
  'pl': 'Polish',
  'ru': 'Russian',
  'tr': 'Turkish',
  'cs': 'Czech',
  'sk': 'Slovak',
  'hu': 'Hungarian',
  'ar': 'Arabic',
  'bg': 'Bulgarian',
  'th': 'Thai',
  'vi': 'Vietnamese',
  'other': 'Other'
};

const BLC_OVERRIDE_TEXT = {
  'en': 'Do you speak English? If so, click here to begin chatting.',
  'zh': '您说中国？如果是，请单击此处以开始聊天。',
  'zh-TW': '您會說中國？會的話，請點擊這裡開始聊天。',
  'zh-HK': '您會說中國？會的話，請點擊這裡開始聊天。',
  'ja': 'あなたは日本語を話せますか？話せる場合は、ここをタップすればチャットを開始します。',
  'ko': '한국어를 할 줄 아세요? 그러면 여기를 탭해서 채팅을 시작하세요.',
  'es': '¿Hablas Español? Si es así, haz clic aquí para comenzar a chatear.',
  'es-MX': '¿Hablas Español? Si es así, haz clic aquí para comenzar a chatear.',
  'fr': 'Parlez-vous Francais? Si oui, cliquez ici pour commencer à discuter.',
  'de': 'Sprichst du deutsch? Wenn ja, klicke hier um zu chatten.',
  'it': 'Parli Italiano? Fai clic qui per iniziare a chattare.',
  'pt': 'Falas Português? Se sim, toca aqui para participares no chat.',
  'pt-BR': 'Você fala Português? Se a resposta é sim, clique aqui para iniciar o chat.',
  'sv': 'Pratar du Svenska? I så fall klicka här för att börja chatta',
  'no': 'Snakker du Norsk? Hvis du gjør det, kan du trykke her for å begynne å chatte.',
  'da': 'Taler du danske? Hvis du gør, skal du trykke her for at gå i gang med at chatte.',
  'nl': 'Spreek je Nederlands? Zo ja, klik hier om te gaan chatten.',
  'fi': 'Osaatko Suomi? Jos osaat, napsauta tästä ja aloita chattailu.',
  'pl': 'Mówisz po Polski? Jeśli tak, kliknij tutaj, aby otworzyć czat.',
  'ru': 'Если вы говорите по-Русский, нажмите здесь, чтобы начать чат.',
  'tr': 'Türkçe biliyor musunuz? Biliyorsanız, sohbete başlamak için buraya dokunun.',
  'cs': 'Mluvíte čeština? Pokud ano, klikněte sem a začněte chatovat.',
  'sk': 'Hovoríš po Slovenčina? Ak áno, klikni sem azačni chatovať.',
  'hu': 'Beszélsz magyar nyelven? Ha igen, kattints ide a chat elindításához.',
  'ar': 'هل تتحدّث اللغة {{language}}؟ إذا كان الأمر كذلك، فانقر هنا لبدء الدردشة.',
  'bg': 'Говорите ли български? Ако е така, щракнете тук, за да започнете да чатите.',
  'th': 'คุณพูดภาษาภาษาไทยได้ไหม ถ้าได้ แตะเพื่อเริ่มแชทได้เลย',
  'vi': 'Bạn có nói tiếng Tiếng Việt không? Nếu có, hãy nhấn vào đây để bắt đầu trò chuyện.'
};

export default Component.extend({
  classNames: ['js-blc-notification'],
  classNameBindings: [':sticky-message'],

  // Public things
  restrictedLanguage: '',
  channelName: '',

  translatedLanguageName: computed('restrictedLanguage', function () {
    return i18n(LANG_CODE_MAPPINGS[this.get('restrictedLanguage')]);
  }),

  notificationTitle: computed('translatedLanguageName', function () {
    let translation = i18n('{{language}} Chat Mode');
    return translation.replace('{{language}}', this.get('translatedLanguageName'));
  }),

  nativeNotificationText: computed('channelName', 'translatedLanguageName', function () {
    let translation = i18n('{{name}} has enabled this chat for {{language}} language speakers only.');
    return translation.replace('{{name}}', this.get('channelName'))
      .replace('{{language}}', this.get('translatedLanguageName'));
  }),

  blcNotificationText: computed('restrictedLanguage', function () {
    return BLC_OVERRIDE_TEXT[this.get('restrictedLanguage')];
  })

});
