import Component from 'ember-component';
import { A as emberA } from 'ember-array/utils';
import injectService from 'ember-service/inject';

export default Component.extend({
  classNames: ['chat-display'],
  session: injectService(),

  // Public things
  messages: emberA(),
  currentUserNick: '',
  hideLinks: false,
  chatDelayDuration: 0,
  canModerate: false,
  isFlashDisabled: false,
  flashTimedOut: false,
  showMessageFlags: false,
  showModerationActions: true,
  showTwitchBotActions: true,

  init() {
    this._super(...arguments);
    this.get('session').withCurrentUser(userData => {
      this.set('userData', userData);
    });
  }
});
