/* global i18n */

import Component from 'ember-component';
import computed from 'ember-computed';
import injectService from 'ember-service/inject';

export default Component.extend({
  classNames: ['textarea-contain'],

  bitsTags: injectService('bits-tags'),
  session: injectService(),
  tracking: injectService(),

  chatPlaceholder: i18n('Send a message'),

  bitsRoom: injectService(),
  isBitsHelperShown: computed.readOnly('bitsRoom.isHelperShown'),
  isBitsTooltipShown: computed.not('bitsRoom.isTooltipHidden'),

  setCaretIndex: function(index) {
    this.get('bitsRoom').setCaretIndex(index);
  },

  actions: {
    disableSuggestions() {
      this.set('room.suggestionsDisabled', true);
    },

    focusChatInputWindow() {
      this.sendAction('focusChatInputWindow', ...arguments);
    },

    getChatSuggestions() {
      return this.get('room.chatSuggestions');
    },

    getChatHashtagSuggestions() {
      return this.get('room.chatHashtagSuggestions');
    },

    sendMessage() {
      this.sendAction('sendMessage', ...arguments);
    },

    track(name, options) {
      options = options || {};

      this.get('tracking').trackEvent({ event: name, data: options});
    }
  }
});
