import Component from 'ember-component';
import computed from 'ember-computed';
import { htmlSafe } from 'ember-string';
import injectService from 'ember-service/inject';

export default Component.extend({
  session: injectService(),
  settings: injectService('chatSettings'),

  chatUser: null,

  colorOptions: computed('settings.colorOptions', 'chatUser.chatColor', function () {
    let myColor = this.get('chatUser.chatColor');
    let colors = this.get('settings.colorOptions') || [];
    return colors.map(function (color) {
      return {
        color,
        isSelected: color === myColor,
        style: htmlSafe(`background-color:${color};`)
      };
    });
  }),

  moreColorsUrl: computed(function () {
    let { isAuthenticated, userData } = this.get('session');

    return isAuthenticated && userData && userData.has_turbo ? '/settings/turbo' : '/products/turbo?ref=more_colors_direct';
  })
});
