/* globals Twitch */
import injectService from 'ember-service/inject';
import Component from 'ember-component';

import on from 'ember-evented/on';

const DEFAULT_LANGUAGE = 'en';

// We store translations here because we want to display it in the user's language. Not the user's.
const TRANSLATIONS = {
  'The name you selected is not available.': {
    'en': 'The name you selected is not available.',
    'ko': '선택한 이름은 사용할 수 없습니다.',
    'ja': 'この名前は使用できません。',
    'zh': '您选择的名称不可用。',
    'zh-cn': '您选择的名称不可用。',
    'zh-tw': '您選擇的名稱無法使用。',
    'zh-hk': '您選擇的名稱無法使用。'
  },
  'The name you selected is too short.': {
    'en': 'The name you selected is too short.',
    'ko': '선택한 이름은 너무 짧습니다.',
    'ja': '名前が短すぎます。',
    'zh': '您选择的名称过短。',
    'zh-cn': '您选择的名称过短。',
    'zh-tw': '您選擇的名稱太短。',
    'zh-hk': '您選擇的名稱太短。'
  },
  'The name you selected is too long.': {
    'en': 'The name you selected is too long.',
    'ko': '선택한 이름은 너무 깁니다.',
    'ja': '名前が長すぎます。',
    'zh': '你选择的名称过长。',
    'zh-cn': '你选择的名称过长。',
    'zh-tw': '您選擇的名稱太長。',
    'zh-hk': '您選擇的名稱太長。'
  },
  'The name you selected contains invalid characters.': {
    'en': 'The name you selected contains invalid characters.',
    'ko': '선택한 이름에는 유효하지 않은 글자가 포함되어 있습니다.',
    'ja': '名前に、無効な文字が含まれています。',
    'zh': '您选择的名称包含无效字符。',
    'zh-cn': '您选择的名称包含无效字符。',
    'zh-tw': '您選擇的名稱含有無效字元。',
    'zh-hk': '您選擇的名稱含有無效字元。'
  },
  'You may not change your display name again.': {
    'en': 'You may not change your display name again.',
    'ko': '닉네임을 바꾸면 다시 변경할 수 없습니다.',
    'ja': '表示ユーザー名は再変更できません。',
    'zh': '可能无法重新更改显示名。',
    'zh-cn': '可能无法重新更改显示名。',
    'zh-tw': '您不可再次變更您的顯示名稱。',
    'zh-hk': '您不可再次變更您的顯示名稱。'
  },
  'You may not change your display name, only the capitalization of it.': {
    'en': 'You may not change your display name, only the capitalization of it.',
    'ko': '닉네임이 변경되지 않았습니다. 한국어 또는 영어 대소문자를 사용해주십시오.',
    'ja': '表示ユーザー名の変更はできません。大文字/小文字の設定のみ可能です。',
    'zh': '您无法更改显示名称，只可以使用大写字母。',
    'zh-cn': '您无法更改显示名称，只可以使用大写字母。',
    'zh-tw': '您不能變更顯示暱稱，只可改變大小寫。',
    'zh-hk': '您不能變更顯示暱稱，只可改變大小寫。'
  },
  'The name you selected contains invalid characters. Chinese, Japanese, and Korean display names can contain only characters in those languages, numerals, and underscores.': {
    'en': 'The name you selected contains invalid characters. Chinese, Japanese, and Korean display names can contain only characters in those languages, numerals, and underscores.',
    'ko': '선택한 이름에 유효하지 않은 문자가 있습니다. 중국어, 일본어, 한국어 닉네임에는 해당 언어의 문자와 숫자 및 밑줄(_)만 사용할 수 있습니다.',
    'ja': '名前に、無効な文字が含まれています。中国語、日本語、韓国語の表示ユーザー名には、それぞれの言語の文字および数字およびアンダースコアしか使用できません。',
    'zh': '所选名称包含无效字符。中文、日语和朝鲜语显示名称仅可包含这些语言中的字符、数字和下划线。',
    'zh-cn': '所选名称包含无效字符。中文、日语和朝鲜语显示名称仅可包含这些语言中的字符、数字和下划线。',
    'zh-tw': '您選擇的名稱含有無效字元。中文、日文和韓文顯示暱稱只能包含這些語言字元、數字和底線。',
    'zh-hk': '您選擇的名稱含有無效字元。中文、日文和韓文顯示暱稱只能包含這些語言字元、數字和底線。'
  },
  headerText: {
    'en': 'Change Your Display Name',
    'ko': '닉네임을 변경해세요',
    'ja': '表示ユーザー名の変更',
    'zh': '更改您的显示名称',
    'zh-cn': '更改您的显示名称',
    'zh-tw': '變更您的顯示暱稱',
    'zh-hk': '變更您的顯示暱稱'
  },
  dismissedText: {
    'en': 'If you change your mind, you can choose an English display name at any time from your account settings.',
    'ko': '혹시 나중에 마음이 바뀌면, 언제든지 계정 설정에서 표시 이름을 한국어로 변경할 수 있습니다.',
    'ja': '気が変わったら、アカウント設定から、いつでも日本語の表示ユーザー名に変更できます。',
    'zh': '如果您改变了主意，可以随时从您的账户设置选择中文显示名称。',
    'zh-cn': '如果您改变了主意，可以随时从您的账户设置选择中文显示名称。',
    'zh-tw': '如果您改變心意，可隨時在帳號設定中選擇中文顯示名稱。',
    'zh-hk': '如果您改變心意，可隨時在帳號設定中選擇中文顯示名稱。'
  },
  notificationText: {
    'en': 'You can now change your display name to include English characters!',
    'ko': '이제 닉네임에 한국어가 포함되도록 변경할 수 있습니다!',
    'ja': '表示ユーザー名に日本語が使用できるようになりました！',
    'zh': '您现在可以更改显示名称，在其中包含中文字符！',
    'zh-cn': '您现在可以更改显示名称，在其中包含中文字符！',
    'zh-tw': '您現在可以加入中文字來變更顯示暱稱！',
    'zh-hk': '您現在可以加入中文字來變更顯示暱稱！'
  },
  modalText: {
    'en': 'Choose your new display name with English characters! This change will be permanent and you may only choose once. Display names that do not adhere to Twitch Rules of Conduct may result in an indefinite suspension of your account.',
    'ko': '한국어로 자신을 표현하세요! 한 번 닉네임을 정하면 다시는 변경할 수 없으니 꼭 신중하게 정해주세요. 트위치 이용정책에 어긋나는 부적절한 닉네임은 영구정지 대상이 될 수 있으니 명심하시길 바랍니다.',
    'ja': '日本の表示名を選びましょう！この変更は永久的なものなので、一度決めたら変更できません。Twitchの論理規約に反する表示名はアカウントの永久的な停止に繋がることもあることもございます。',
    'zh': '请选择一个中文的昵称! 请再三的确认选字无误，因为这个设定是永久的! 也请务必注意，任何违反Twitch使用者条款的恶意名称，帐号将被永久禁用。(自觉不妙的名字，就请不要取唷! )',
    'zh-cn': '请选择一个中文的昵称! 请再三的确认选字无误，因为这个设定是永久的! 也请务必注意，任何违反Twitch使用者条款的恶意名称，帐号将被永久禁用。(自觉不妙的名字，就请不要取唷! )',
    'zh-tw': '請選擇一個中文的暱稱! 請再三的確認選字無誤，因為這個設定是永久的! 也請務必注意，任何違反Twitch使用者條款的惡意名稱，帳號將被永久禁用。(自覺不妙的名字，就請不要取唷! )',
    'zh-hk': '請選擇一個中文的暱稱! 請再三的確認選字無誤，因為這個設定是永久的! 也請務必注意，任何違反Twitch使用者條款的惡意名稱，帳號將被永久禁用。(自覺不妙的名字，就請不要取唷! )'
  },
  loginText: {
    'en': 'Your URL ({{url}}) will not change. You will still use {{login}} to log in.',
    'ko': '사용자의 URL ({{url}})은 변경되지 않으며, 계속해서 {{login}}(을)를 사용해 로그인할 수 있습니다.',
    'ja': 'ご利用のURL（{{url}}）は変わりません。また、ログインの際は{{login}}をご使用ください。',
    'zh': '您的 URL ({{url}}) 不会更改，您仍将使用 {{login}} 进行登录。',
    'zh-cn': '您的 URL ({{url}}) 不会更改，您仍将使用 {{login}} 进行登录。',
    'zh-tw': '您的 URL ({{url}}) 不會改變，您仍然可使用 {{login}} 執行登入。',
    'zh-hk': '您的 URL ({{url}}) 不會改變，您仍然可使用 {{login}} 執行登入。'
  },
  changeNow: {
    'en': 'Change Now',
    'ko': '지금 변경',
    'ja': '今すぐ変更する',
    'zh': '立即更改',
    'zh-cn': '立即更改',
    'zh-tw': '立即變更',
    'zh-hk': '立即變更'
  },
  notNow: {
    'en': 'Not Now',
    'ko': '나중에',
    'ja': '後で',
    'zh': '后来',
    'zh-cn': '后来',
    'zh-tw': '後來',
    'zh-hk': '後來'
  },
  ok: {
    'en': 'Okay',
    'ko': '승인',
    'ja': '確認',
    'zh': '好',
    'zh-cn': '好',
    'zh-tw': '好',
    'zh-hk': '好'
  },
  cancel: {
    'en': 'Cancel',
    'ko': '취소',
    'ja': 'キャンセル',
    'zh': '取消',
    'zh-cn': '取消',
    'zh-tw': '取消',
    'zh-hk': '取消'
  },
  back: {
    'en': 'Back',
    'ko': '뒤로가기',
    'ja': '戻る',
    'zh': '返回',
    'zh-cn': '返回',
    'zh-tw': '返回',
    'zh-hk': '返回'
  },
  submit: {
    'en': 'Submit',
    'ko': '변경 사항 제출',
    'ja': '変更を送信',
    'zh': '提交更改',
    'zh-cn': '提交更改',
    'zh-tw': '送出變更項目',
    'zh-hk': '送出變更項目'
  },
  lastChanceAppearText: {
    'en': 'This is how your name will appear in chat:',
    'ko': '채팅 중 이름 표시 방법:',
    'ja': 'あなたのユーザー名は、チャット内でこのように表示されます:',
    'zh': '您的名字在聊天中将如下显示：',
    'zh-cn': '您的名字在聊天中将如下显示：',
    'zh-tw': '您在聊天室中顯示的名稱為：',
    'zh-hk': '您在聊天室中顯示的名稱為：'
  },
  lastChancePermanentText: {
    'en': 'Please review it because the change will be permanent — requests to undo it will not be honored! Display names that do not adhere to Twitch Rules of Conduct may result in an indefinite suspension of your account.',
    'ko': '다시 한 번 확인해주세요. 한번 변경하면 다시는 바꿀 수 없습니다! — 트위치 이용정책에 어긋나는 부적절한 닉네임은 영구정지 대상이 될 수 있으니 명심하시길 바랍니다.',
    'ja': '確定後は変更できませんので、再度確認してくださいー元に戻すリクエストは受け付けられません。Twitchの論理規定に反する表示名はアカウントの永久的な停止に繋がることもございます。',
    'zh': '请再三的确认选字无误，一旦点下去，这个名称就是永久的喔! 永久的喔! 永久的喔，因为很重要所以讲三次! 也请大家务必注意，任何违反Twitch使用者条款规范的恶意名称，帐号将被永久禁用。(自觉不妙的名字，就请不要取唷! )',
    'zh-cn': '请再三的确认选字无误，一旦点下去，这个名称就是永久的喔! 永久的喔! 永久的喔，因为很重要所以讲三次! 也请大家务必注意，任何违反Twitch使用者条款规范的恶意名称，帐号将被永久禁用。(自觉不妙的名字，就请不要取唷! )',
    'zh-tw': '請再三的確認選字無誤，一旦點下去，這個名稱就是永久的喔! 永久的喔! 永久的喔，因為很重要所以講三次! 也請大家務必注意，任何違反Twitch使用者條款規範的惡意名稱，帳號將被永久禁用。(自覺不妙的名字，就請不要取唷! )',
    'zh-hk': '請再三的確認選字無誤，一旦點下去，這個名稱就是永久的喔! 永久的喔! 永久的喔，因為很重要所以講三次! 也請大家務必注意，任何違反Twitch使用者條款規範的惡意名稱，帳號將被永久禁用。(自覺不妙的名字，就請不要取唷! )'
  },
  successMsg: {
    'en': 'Your display name has been set! Please wait a few minutes for it to appear.',
    'ko': '닉네임이 설정되었습니다! 표시될 때까지 잠시만 기다려 주세요.',
    'ja': '表示ユーザー名を設定しました！ 表示されるまで数分かかりますので、しばらくお待ちください。',
    'zh': '已设置您的显示名称！请等待几分钟以使其显示出来。',
    'zh-cn': '已设置您的显示名称！请等待几分钟以使其显示出来。',
    'zh-tw': '已設定您的顯示名稱！請稍候，系統將於數分鐘後顯示名稱。',
    'zh-hk': '已設定您的顯示名稱！請稍候，系統將於數分鐘後顯示名稱。'
  }
};

export default Component.extend({
  api: injectService(),
  // NOTICE: The login service is deprecated, plesase use the session service.
  // See app/services/SESSION.md for more details.
  login: injectService(),
  tracking: injectService(),

  classNames: ['js-display-name-notification'],
  classNameBindings: [':sticky-message'],

  shouldShowDismissed: false,
  showLastChance: false,
  hasError: false,

  setStrings: on('init', function () {
    let userLanguage = Twitch.receivedLanguage || DEFAULT_LANGUAGE;
    this.set('userLanguage', userLanguage);

    this.set('headerText', TRANSLATIONS.headerText[userLanguage]);
    this.set('dismissedText', TRANSLATIONS.dismissedText[userLanguage]);
    this.set('notificationText', TRANSLATIONS.notificationText[userLanguage]);
    this.set('changeNow', TRANSLATIONS.changeNow[userLanguage]);
    this.set('notNow', TRANSLATIONS.notNow[userLanguage]);
    this.set('ok', TRANSLATIONS.ok[userLanguage]);
    this.set('submit', TRANSLATIONS.submit[userLanguage]);
    this.set('modalText', TRANSLATIONS.modalText[userLanguage]);
    this.set('lastChanceAppearText', TRANSLATIONS.lastChanceAppearText[userLanguage]);
    this.set('lastChancePermanentText', TRANSLATIONS.lastChancePermanentText[userLanguage]);

    let login = this.get('login.userData.login');
    let url = `twitch.tv/${login}`;
    let loginText = TRANSLATIONS.loginText[userLanguage];
    loginText = loginText.replace('{{url}}', url);
    loginText = loginText.replace('{{login}}', login);
    this.set('loginText', loginText);

    this.set('cancel', TRANSLATIONS.cancel[userLanguage]);
    this.set('back', TRANSLATIONS.back[userLanguage]);
  }),

  actions: {
    changeDisplayname(displayname) {
      let login = this.get('login.userData.login');
      if (!login) { return; }
      this.get('api').request('put', `/kraken/users/${login}`, {displayname})
        .then(() => {
          if (this.isDestroyed) { return; }
          this.get('tracking').trackEvent({
            event: 'displayname_change',
            data: {
              login,
              is_partner: !!this.get('login.userData.is_partner'),
              is_broadcaster: !!this.get('login.userData.is_broadcaster'),
              user_language: this.get('userLanguage')
            }
          });
          this.closeModal();
          Twitch.notify.success(TRANSLATIONS.successMsg[this.get('userLanguage')]);
          this.sendAction('close');
        })
        .catch((response) => {
          if (this.isDestroyed) { return; }
          if (!response || !response.responseText) {
            throw response;
          }

          let parsedError;
          let errorMsg;
          try {
            parsedError = JSON.parse(response.responseText).message;
          } catch (e) {
            errorMsg = TRANSLATIONS['The name you selected is not available.'][this.get('userLanguage')];
          }
          if (!errorMsg) {
            errorMsg = TRANSLATIONS[parsedError][this.get('userLanguage')];
          }
          this.get('tracking').trackEvent({
            event: 'displayname_error',
            data: {
              error_msg: errorMsg,
              user_language: this.get('userLanguage')
            }
          });
          this.set('errorMsg', errorMsg);
          this.set('hasError', true);
        });
    },

    showDismissed() {
      this.set('shouldShowDismissed', true);
    },

    showLastChance() {
      this.set('showLastChance', true);
    },

    showChangeDisplayname() {
      this.set('showLastChance', false);
    },

    openChangeDisplaynameModal() {
      this.sendAction('openInModal', 'changeDisplayname', this);
    },

    closeModal() {
      this.set('hasError', false);
      this.set('showLastChance', false);
      this.sendAction('closeModal');
    }
  }

});
