import Component from 'ember-component';
import injectService from 'ember-service/inject';
import { capitalize } from 'web-client/helpers/chat/chat-line-helpers';
import { formatDisplayName } from 'web-client/helpers/format-display-name';
import computed from 'ember-computed';
import { htmlSafe } from 'ember-string';

export default Component.extend({
  badges: injectService(),
  session: injectService(),

  chatUser: null,

  userData: computed.readOnly('session.userData'),

  badgeSet: computed('chatUser.chatBadges', function () {
    let badgesTag = this.get('chatUser.chatBadges') || [];
    return this.get('badges').getBadgesData(badgesTag);
  }),

  colorStyle(color) {
    if (color) {
      // Sanitize CSS color values, permitting only hex `#f0f0f0` and `lightgrey` style values
      color = color.replace(/[^0-9a-zA-Z#]/g, '');
      return `color:${color}`;
    }
    return '';
  },

  fromStyle: computed('chatUser.chatColor', function () {
    return htmlSafe(this.colorStyle(this.get('chatUser.chatColor')));
  }),

  fromText: computed('userData.name', 'userData.login', function () {
    let displayName = this.get('userData.name');
    let login = this.get('userData.login');
    if (displayName) {
      return formatDisplayName(login, displayName);
    }
    return capitalize(login);
  }),

  actions: {
  }
});
