import Component from 'ember-component';

export default Component.extend({
  classNames: ['ignore-form'],
  // Public things
  username: '',

  didSubmitEmptyForm: false,

  termsOfServiceUrl: 'https://www.twitch.tv/p/terms_of_service',

  actions: {
    sendReason: function () {
      if (this.$('.reason-select select').val() === '0') {
        this.set('didSubmitEmptyForm', true);
      } else {
        this.sendAction('sendReason', this.$('.reason-select select').val());
      }
    },
    openTermsOfService: function () {
      window.open(this.get('termsOfServiceUrl'), '_blank');
    }
  }
});
