import Component from 'ember-component';
import observer from 'ember-metal/observer';

export default Component.extend({

  click: function () {
    this.sendAction();
  },

  _brieflyShowInvitation: observer('invitation.room.name', function () {
    let self = this,
        HIDE_INVITATION_DELAY = 10000;
    if (this.get('invitation.room.name')) {
      if (this.showTimeout) {
        clearTimeout(this.showTimeout);
      }
      if (this.hideTimeout) {
        clearTimeout(this.hideTimeout);
      }
      this.showTimeout = setTimeout(function () { self.set('isOpen', true);  });
      this.hideTimeout = setTimeout(function () { self.set('isOpen', false); }, HIDE_INVITATION_DELAY);
    }
  })

});
