/* We are purposefully not using computed properties here.
 * Please be very careful when accessing data as it likely won't be bound
 * Please ask the chat team if you have any questions
*/

import ChatLineComponent from 'web-client/components/chat/chat-line/component';
import injectService from 'ember-service/inject';
import { capitalize } from 'web-client/helpers/chat/chat-line-helpers';
import { formatDisplayName } from 'web-client/helpers/format-display-name';
import { assign } from 'ember-platform';
import getter from 'web-client/utilities/getter';

export default ChatLineComponent.extend({
  tagName: 'li',

  classNameBindings: [
    ':message-line',
    ':chat-line',
    'msgObject.style',
    'hasSystemMsg:special-message',
    'isHistorical:historical-message',
    'isHistoryStyleExperiment:chat-line--greyed-out-less',
    'isHistoryStyleExperiment:chat-line--force-timestamp',
    'msgObject.flaggedForReview:special-message',
    'msgObject.flaggedForReview:brick',
    'msgObject.flaggedForReview:brick--marked',
    'msgObject.flaggedForReview:brick--theme-red'
  ],

  badges: injectService(),
  tracking: injectService(),
  api: injectService(),

  badgeSet: getter(function() {
    let badgesTag = this.get('msgObject.tags.badges') || [];
    let badges = this.get('badges').getBadgesData(badgesTag);
    return badges;
  }),

  hasSystemMsg: getter(function () {
    return this.get('msgObject.tags.system-msg.length') > 0 || this.get('msgObject.from') === 'twitchnotify';
  }),

  systemMsg: getter(function () {
    return this.get('msgObject.tags.system-msg') || this.get('msgObject.message');
  }),

  isHistorical: getter(function() {
    return this.get('msgObject.tags.historical');
  }),

  isHistoryStyleExperiment: getter(function() {
    return this.get('isHistorical') && this.get('msgObject.inHistoryStyleExperiment');
  }),

  hasMessageBody: getter(function () {
    return this.get('msgObject.message.length') > 0;
  }),

  shouldRenderMessageBody: getter(function () {
    return !this.get('hasSystemMsg') || (this.get('hasMessageBody') && !(this.get('msgObject.from') === 'twitchnotify'));
  }),

  fromText: getter(function () {
    let displayName = this.get('msgObject.tags.display-name');
    let login = this.get('msgObject.from');
    if (displayName) {
      return formatDisplayName(login, displayName);
    }
    return capitalize(login);
  }),

  richContent: getter(function () {
    return this.get('msgObject.tags.content');
  }),

  didRender() {
    this._super(...arguments);

    if (this.get('postRenderAction') !== undefined) {
      this.get('postRenderAction')();
    }
  },

  actions: {
    timeout(msgId, user) {
      this.sendAction('timeoutUser', {
        msg_id: msgId,
        user,
        tracking_source: 'quick_mod_buttons'
      });
    },
    unban(msgId, user) {
      this.sendAction('unbanUser', {
        msg_id: msgId,
        user,
        tracking_source: 'quick_mod_buttons'
      });
    },
    ban(msgId, user) {
       this.sendAction('banUser', {
        msg_id: msgId,
        user,
        tracking_source: 'quick_mod_buttons'
      });
    },
    undelete() {
      this.set('msgObject.deleted', false);
    },
    clickedRiskYes(msgId) {
      this.set('hasClickedFlaggedMessage', true);
      this.get('tracking').trackEvent({
        event: 'classify_risk_score',
        services: ['spade'],
        data: assign({
          clicked_risk_yes: true,
          msg_id: msgId
        }, this.get('roomTrackingData'))
      });
    },
    clickedRiskNo(msgId) {
      this.set('hasClickedFlaggedMessage', true);
      this.get('tracking').trackEvent({
        event: 'classify_risk_score',
        services: ['spade'],
        data: assign({
          clicked_risk_yes: false,
          msg_id: msgId
        }, this.get('roomTrackingData'))
      });
    },
    clickedTwitchBotResponse(msgId, type) {
      let payload = {msg_id: msgId};
      if (type === 'yes') {
        this.get('api').authRequest('post', "chat/twitchbot/approve", payload, {version: 5});
      } else if (type === 'no') {
        this.get('api').authRequest('post', "chat/twitchbot/deny", payload, {version: 5});
      }
      this.set('hasClickedFlaggedMessage', true);
      this.get('tracking').trackEvent({
        event: 'clicked_twitchbot_response',
        services: ['spade'],
        data: assign({
          click_type: type,
          msg_id: msgId
        }, this.get('roomTrackingData'))
      });
    },
    clickedRiskFlag(msgId) {
      this.set('hasClickedRiskFlag', true);
      this.get('tracking').trackEvent({
        event: 'classify_risk_score',
        services: ['spade'],
        data: assign({
          clicked_risk_yes: false,
          msg_id: msgId
        }, this.get('roomTrackingData'))
      });
    },
    clickedRiskUnflag(msgId) {
      this.set('hasClickedRiskFlag', false);
      this.get('tracking').trackEvent({
        event: 'classify_risk_score',
        services: ['spade'],
        data: assign({
          clicked_risk_yes: true,
          msg_id: msgId
        }, this.get('roomTrackingData'))
      });
    },
    showModOverlay(sender) {
      let $this = this.$();
      this.sendAction('showModOverlay', {
        left: $this.offset().left,
        top: $this.offset().top + $this.height(),
        sender
      });
    }
  }
});
