/* globals Twitch */
import Component from 'ember-component';
import injectService from 'ember-service/inject';
import SendRouteActionMixin from 'web-client/mixins/send-route-action';
import computed from 'ember-computed';
import { nativeBroadcastsExperiment } from 'web-client/utilities/chat-sticky';

const LANGUAGE_PREDICATE = Twitch && Twitch.receivedLanguage ? Twitch.receivedLanguage.split('-')[0] : 'en';

export default Component.extend(SendRouteActionMixin, {
  classNames: ['js-nb-notification'],
  classNameBindings: [':sticky-message', 'native-broadcast-notification'],

  globals: injectService(),
  layout: injectService(),
  tracking: injectService(),
  session: injectService(),
  chatSticky: injectService(),

  didRender() {
    this._super(...arguments);
    this.get('tracking').trackEvent({
      event: 'see_nb_sticky',
      data: {
        channel: this.get('channelName'),
        login: this.get('session.userData.login'),
        user_language: Twitch.receivedLanguage,
        url: window.location.href,
        browser: this.get('globals.browserName'),
        collapse_right: this.get('layout.isRightColumnClosed')
      }
    });
  },

  notificationTitle: computed('languageContent', function() {
    return this.get('languageContent').title;
  }),

  notificationText: computed('languageContent', function() {
    return this.get('languageContent').text;
  }),

  languageContent: computed(function() {
    try {
      let langIsAvailable = LANGUAGE_PREDICATE in nativeBroadcastsExperiment.lang_mappings;
      let translatedLanguage = langIsAvailable ? LANGUAGE_PREDICATE : 'en';
      return nativeBroadcastsExperiment.lang_mappings[translatedLanguage];
    } catch (e) {
      console.error(`${e} -- experiment JSON missing necessary fields`);
      return null;
    }
  }),

  goToHost(url) {
    this.get('tracking').trackEvent({
      event: 'click_nb_sticky',
      data: {
        url: window.location.href,
        channel: this.get('channelName'),
        login: this.get('session.userData.login'),
        user_language: Twitch.receivedLanguage,
        browser: this.get('globals.browserName'),
        destination_url: url,
        destination_lang: nativeBroadcastsExperiment.streams[url].lang
      }
    });
    this.sendRouteAction('handleStreamClick', { id: url });
  }

});
