/* global i18n */

import Component from 'ember-component';
import computed from 'ember-computed';
import { htmlSafe } from 'ember-string';

import { EMOTICONS_V1_URL } from 'web-client/utilities/urls/static-cdn';

const RESUB_NOTICE_TEMPLATE = i18n(`It's your {{monthlength}} month anniversary!`);
const DETAILED_RESUB_NOTICE_TEMPLATE = i18n(`Hooray! Let {{broadcastername}} know it's your {{monthlength}} month anniversary.`);
const ULTRA_RARE_EMOTICON_NECK_ANIMATION = 99;
const RARE_EMOTICON_IDS = [
  '354', // 4Head
  '49106', // CorgiDerp
  '4339', // EleGiggle
  '48', // FunRun
  '25', // Kappa
  '55338', // KappaPride
  '70433', // KappaRoss
  '1902', // Keepo
  '68856', // MingLee
  '81103', // OhMyDog
  '76171', // PartyTime
  '27509' // PermaSmug
];

export const SHARE_MESSAGE_CHARACTER_LIMIT = 255;

export default Component.extend({
  classNames: ['js-resub-notification', 'top-notification--resub'],

  // Passed in properties:
  channelName: null,
  closeResubNotification: null,
  postResubMessage: null,

  // Own properties:
  isShowingBalloon: false,
  isSharingMessage: false,
  message: '',

  resubNotice: computed('resubNotification.token_month', function () {
    let month = this.get('resubNotification.token_month');

    return RESUB_NOTICE_TEMPLATE.replace('{{monthlength}}', month);
  }),

  detailedResubNotice: computed('channelName', 'resubNotification.token_month', function () {
    let channelName = this.get('channelName');
    let month = this.get('resubNotification.token_month');
    let boldedName = `<span class="strong">${ channelName }</span>`;

    let detailedResubNotice = DETAILED_RESUB_NOTICE_TEMPLATE
      .replace('{{broadcastername}}', boldedName)
      .replace('{{monthlength}}', month);

    return htmlSafe(detailedResubNotice);
  }),

  randomEmoticonUrl: computed(function () {
    let emoticonId = this._randomizeEmoticonId();

    return `${ EMOTICONS_V1_URL }/${ emoticonId }/2.0`;
  }),

  isUltraRareEmoticonNeckAnimation: computed(function () {
    return this._randomizeUltraRareEmoticonNeckAnimation() === ULTRA_RARE_EMOTICON_NECK_ANIMATION;
  }),

  isOverCharacterLimit: computed.gt('message.length', SHARE_MESSAGE_CHARACTER_LIMIT),

  overCharacterLimitButtonText: computed('message.length', function () {
    return SHARE_MESSAGE_CHARACTER_LIMIT - this.get('message.length');
  }),

  _randomizeEmoticonId() {
    let randomEmoticonIndex = Math.floor(Math.random() * RARE_EMOTICON_IDS.length);

    return RARE_EMOTICON_IDS[randomEmoticonIndex];
  },

  _randomizeUltraRareEmoticonNeckAnimation() {
    return Math.floor(Math.random() * ULTRA_RARE_EMOTICON_NECK_ANIMATION);
  },

  actions: {
    setIsShowingBalloon(isShowing) {
      this.set('isShowingBalloon', isShowing);
    },

    shareMessage() {
      if (this.get('isOverCharacterLimit') || this.get('isSharingMessage')) { return; }

      this.set('isSharingMessage', true);

      let resubTokenId = this.get('resubNotification.token_id');
      let message = this.get('message');
      let postResubMessage = this.get('postResubMessage');

      return postResubMessage(resubTokenId, message).then(() => {
        if (this.isDestroyed) { return; }

        this.get('closeResubNotification')();
      }).finally(() => {
        if (this.isDestroyed) { return; }

        this.set('isSharingMessage', false);
      });
    }
  }
});
