import Component from 'ember-component';
import { capitalize } from 'web-client/helpers/chat/chat-line-helpers';
import { formatDisplayName } from 'web-client/helpers/format-display-name';
import getter from 'web-client/utilities/getter';

/*
  Animated component for individual suggestions that also support for actions with the mouse.
*/
export default Component.extend({
  didInsertElement() {
    this._super(...arguments);
    /* Make animations work. */
    if (this.get('suggestion.highlighted')) {
      this.$().hide().fadeIn(100);
      this.$().addClass('highlighted');
    }
  },

  formattedSuggestion: getter(function () {
    let displayName = this.get('suggestion.name');
    let login = this.get('suggestion.id');

    if (displayName) {
      return formatDisplayName(login, displayName);
    }
    return capitalize(login);
  }),

  mouseEnter() {
    this.sendAction('updateSuggestionIndex', this.get('suggestion.index'));
  },

  mouseUp() {
    this.sendAction('selectSuggestion', this.get('suggestion.name'));
  }
});
