/* global Twitch */
import computed from 'ember-computed';

import Component from 'ember-component';

let ListRowComponent = Component.extend({
  capitalizedName: computed('viewer.chatter', function() {
    let chatter = this.get('viewer.chatter');
    return Twitch.display.capitalize(chatter);
  }),

  actions: {
    clickUser() {
      let el = this.$();
      if (el) {
        this.sendAction('showModOverlay', {
          left: el.offset().left,
          top: el.offset().top + el.height(),
          sender: this.get('viewer.chatter')
        });
      }
    }
  }
});

ListRowComponent.reopenClass({
  positionalParams: ['viewer']
});

export default ListRowComponent;
