/* globals i18n, _ */
import Component from 'ember-component';
import computed from 'ember-computed';

const HEADER_HEIGHT = 38,
      POPOUT_HEIGHT = 380,
      POPOUT_WIDTH = 275;

export default Component.extend({
  classNames: ['js-chat-viewers'],
  classNameBindings: [':chatters-view', 'isPopped:viewer-list-popped-out'],
  isPopped: false,
  didInsertElement() {
    let $el = this.$();
    $el.css({overflow: "visible"});

    $el.animate({height: "100%"}, 200, () => {
      this.setListDimensions({
        height: $el.height(),
        width: $el.width()
      });
    });
    this.set('width', $el.width());
  },
  setListDimensions(options) {
    this.$('.js-ember-collection')
        .width(options.width)
        .height(options.height - HEADER_HEIGHT)
        .css({ position: 'relative' });
  },

  lines: computed('model.chatters', function() {
    let lines = [],
        chatters = this.get('model.chatters') || {};

    if (chatters.staff && chatters.staff.length) {
      lines.push({category: i18n('Staff')}, {chatter: ''});
      lines = lines.concat(_.map(chatters.staff, function (chatter) {return {chatter: chatter};}));
    }
    if (chatters.admins && chatters.admins.length) {
      lines.push({category: i18n('Admins')}, {chatter: ''});
      lines = lines.concat(_.map(chatters.admins, function (chatter) {return {chatter: chatter};}));
    }
    // jscs:disable requireCamelCaseOrUpperCaseIdentifiers
    if (chatters.global_mods && chatters.global_mods.length) {
      lines.push({category: i18n('Global Moderators')}, {chatter: ''});
      lines = lines.concat(_.map(chatters.global_mods, function (chatter) {return {chatter: chatter};}));
    }
    // jscs:enable requireCamelCaseOrUpperCaseIdentifiers
    if (chatters.moderators && chatters.moderators.length) {
      lines.push({category: i18n('Moderators')}, {chatter: ''});
      lines = lines.concat(_.map(chatters.moderators, function (chatter) {return {chatter: chatter};}));
    }
    if (chatters.viewers && chatters.viewers.length) {
      lines.push({category: i18n('Viewers')}, {chatter: ''});
      lines = lines.concat(_.map(chatters.viewers, function (chatter) {return {chatter: chatter};}));
    }

    return lines;
  }),

  isEmpty: computed.empty('model.chatters'),

  actions: {
    popoutViewerList() {
      this.$().draggable({handle: '.drag_handle'});
      this.set('isPopped', true);
      this.setListDimensions({
        height: POPOUT_HEIGHT,
        width: POPOUT_WIDTH
      });
    }
  }
});
