import Component from 'ember-component';
import injectService from 'ember-service/inject';
import SendRouteActionMixin from 'web-client/mixins/send-route-action';
import { viewingPartiesExperiment } from 'web-client/utilities/chat-sticky';

export default Component.extend(SendRouteActionMixin, {
  classNames: ['js-vp-notification'],
  classNameBindings: [':sticky-message'],

  chatSticky: injectService(),
  tracking: injectService(),
  session: injectService(),
  globals: injectService(),
  layout: injectService(),

  didRender() {
    this.get('tracking').trackEvent({
      event: 'see_viewer_party_sticky',
      data: {
        channel: this.get('channelName'),
        login: this.get('session.userData.login'),
        url: window.location.href,
        browser: this.get('globals.browserName'),
        channel_hosts: this.get('chatSticky.hostsArray'),
        collapse_right: this.get('layout.isRightColumnClosed')
      }
    });
  },

  notificationTitle: viewingPartiesExperiment.title,
  notificationText: viewingPartiesExperiment.text,

  /*
    "footer":{
      "leadup": <string>,
      "text": <string to embed with link>,
      "link": <string link>
    },
  */
  footer: viewingPartiesExperiment.footer,

  goToHost(host) {
    this.get('tracking').trackEvent({
      event: 'click_viewer_party_sticky',
      data: {
        destination_url: host.url,
        hostOrder: host.order,
        url: window.location.href,
        channel: this.get('channelName'),
        login: this.get('session.userData.login'),
        browser: this.get('globals.browserName')
      }
    });
    this.sendRouteAction('handleStreamClick', { id: host.url });
  },
  openLink(url) {
    window.open(url, '_blank');
  }

});
