import computed from 'ember-computed';
import ChatLineComponent from 'web-client/components/chat/chat-line/component';
import { capitalize } from 'web-client/helpers/chat/chat-line-helpers';
import { htmlSafe } from 'ember-string';
import injectService from 'ember-service/inject';

export default ChatLineComponent.extend({
  classNameBindings: [':whisper-line', ':chat-line', 'isReceivedWhisper:whisper-incoming:whisper-outgoing'],

  // nonce is used to track whisper reliability. This is used by web-client/services/whispers-shim
  // as of 4/12/16
  attributeBindings: ['msgObject.nonce:data-nonce'],

  tagName: 'li',

  // NOTE: Disabling linkification to prevent spread of malware on twitch via whispers.
  // We should enable linkification after we have proper measures to protect our users.
  enableLinkification: false,

  badges: injectService(),

  toStyle: computed('msgObject.toColor', function () {
    return htmlSafe(this.colorStyle(this.get('msgObject.toColor')));
  }),

  isReceivedWhisper: computed('currentUserNick', 'msgObject.from', function () {
    return this.get('currentUserNick') !== this.get('msgObject.from');
  }),

  badgeSet: computed(function() {
    let badges = [];

    if (this.get('isReceivedWhisper')) {
      let badgesTag = this.get('msgObject.tags.badges') || [];
      badges = this.get('badges').getBadgesData(badgesTag);
    }
    // TODO: Handle badges for when user sends inline-whispers

    return badges;
  }),

  fromText: computed("msgObject.tags.display-name", "msgObject.from", function () {
    return this.get('msgObject.tags.display-name') || capitalize(this.get('msgObject.from'));
  }),

  toText: computed('msgObject.tags.recipient-display-name', 'msgObject.to', function () {
    return this.get('msgObject.tags.recipient-display-name') || capitalize(this.get('msgObject.to'));
  }),

  actions: {
    showModOverlay(sender) {
      let $this = this.$();
      this.sendAction('showModOverlay', {
        left: $this.offset().left,
        top: $this.offset().top + $this.height(),
        sender
      });
    }
  }
});
