import Component from 'ember-component';
import computed from 'ember-computed';
import { assert } from 'ember-metal/utils';

const CLIPS_404_IMAGE = 'https://clips-media-assets.twitch.tv/img/clips-404-320x180.png';

export default Component.extend({
  attributeBindings: ['selector:data-test-selector'],
  selector: 'clips-card-row',

  // Note: because preventDefault is true for events fired by elements with actions,
  // some sort of click handling behavior must be implemented for this component to function
  onClipClick() {},
  clip: null,
  clipIndex: null,

  init() {
    this._super(...arguments);

    assert('{{clips-card-row}} requires argument "clips"', !!this.get('clip'));
  },

  clipUrl: computed.readOnly('clip.url'),

  fallbackThumbnail: CLIPS_404_IMAGE,

  actions: {
    onClipClick() {
      this.get('onClipClick')(this.get('clip'), this.get('clipIndex'));
    }
  }
});
