import Component from 'ember-component';
import computed from 'ember-computed';

export default Component.extend({
  attributeBindings: ['selector:data-test-selector'],
  selector: 'clips-card-rows',

  clips: null,
  activeClip: null,
  activeClipIndex: null,
  isPlaybackModalActive: computed.notEmpty('activeClip'),
  shouldShowRemoveModal: false,
  shouldShowReportModal: false,
  shouldShowModal: computed.or('isPlaybackModalActive', 'shouldShowRemoveModal'),
  clipModalSize: null,

  actions: {
    openPlaybackModal(clip, clipIndex) {
      this.set('clipModalSize', 'containerSm');
      this.set('activeClip', clip);
      this.set('activeClipIndex', clipIndex);
    },
    closePlaybackModal() {
      this.set('activeClip', null);
    },
    openRemoveModal() {
      this.set('clipModalSize', 'default');
      this.set('shouldShowRemoveModal', true);
    },
    openReportModal() {
      this.set('clipModalSize', 'default');
      this.set('shouldShowReportModal', true);
    },
    closeRemoveModal() {
      this.set('clipModalSize', 'containerSm');
      this.set('shouldShowRemoveModal', false);
    },
    closeReportModal() {
      this.set('clipModalSize', 'containerSm');
      this.set('shouldShowReportModal', false);
    },
    closeModal() {
      this.set('clipModalSize', 'containerSm');
      this.set('shouldShowRemoveModal', false);
      this.set('shouldShowReportModal', false);
      this.set('activeClip', null);
    },
    loadMore() {
      this.get('clips').fetchNextPage();
    }
  }
});
