/* globals i18n */
import Component from 'ember-component';
import injectService from 'ember-service/inject';

export default Component.extend({
  clipsAPI: injectService('clips'),
  notify: injectService(),

  clip: null,
  closeRemoveModal: () => {},
  closeModal: () => {},

  init() {
    this._super(...arguments);
  },

  actions: {
    closeRemoveModal() {
      this.get('closeRemoveModal')();
    },
    onRemoveClip() {
      const slug = this.get('clip.id');
      const notify = this.get('notify');

      this.get('clipsAPI').removeClipRecord(slug).then(() => {
        notify.success(i18n('Clip successfully deleted.'));
      }).catch(() => {
        notify.error(i18n('There was a problem deleting this clip.'));
      });

      this.get('closeModal')();
    }
  }
});
