/* globals i18n */
import Component from 'ember-component';
import injectService from 'ember-service/inject';

export const REPORT_REASONS = {
  tos_ban_evasion: i18n('Site Suspension Evasion'),
  chat_ban_evasion: i18n('Chat Ban Evasion'),
  selfharm: i18n('Self-Harm'),
  harm: i18n('Attempts or Threats to Harm'),
  harassment: i18n('Harassment'),
  hate_speech: i18n('Hate Speech'),
  offensive_username: i18n('Offensive Username'),
  impersonation: i18n('Impersonation'),
  spam: i18n('Spam, Scams, or Other Malicious Content'),
  porn: i18n('Porn or Other Sexually Explicit Content'),
  gore: i18n('Gore or Other Obscene Content'),
  underaged: i18n('Underaged'),
  cheating: i18n('Cheating in Online Game'),
  prohibited: i18n('Prohibited Game'),
  nongaming: i18n('Non-Gaming Content'),
  creative_conduct: i18n('Creative Conduct Violation'),
  music_conduct: i18n('Music Conduct Violation'),
  social_eating_violation: i18n('Social Eating Conduct Violation'),
  bits_violation: i18n('Bits Acceptable Use Policy Violation'),
  offensive_badge: i18n('Offensive Badge'),
  other: i18n('Other Terms of Service Violation')
};

export default Component.extend({
  clipsAPI: injectService('clips'),

  clip: null,
  reasonsKeys: Object.keys(REPORT_REASONS),
  reasons: REPORT_REASONS,
  closeReportModal: () => {},
  closeModal: () => {},
  description: '',
  reason: '',
  buttonDisabled: true,
  notify: injectService(),

  init() {
    this._super(...arguments);
  },

  actions: {
    closeReportModal() {
      this.get('closeReportModal')();
    },
    updateReason(selectedReason) {
      this.set('reason', selectedReason);
      this.send('checkValidation');
    },
    checkValidation() {
      const description = this.get('description');
      const reason = this.get('reason');

      this.set('buttonDisabled', !(description && reason));
    },
    onReportClip() {
      const slug = this.get('clip.id');
      const reason = this.get('reason');
      const description = this.get('description');
      const notify = this.get('notify');

      this.get('clipsAPI').reportClip(slug, reason, description).then(() => {
        notify.success(i18n('Clip successfully deleted.'));
      }).catch(() => {
        notify.error(i18n('There was a problem reporting this clip.'));
      });

      this.get('closeModal')();
    }
  }
});
