import Component from 'ember-component';
import computed from 'ember-computed';
import injectService from 'ember-service/inject';

export default Component.extend({
  testSelector: 'clips-more-button-root',
  attributeBindings: ['testSelector:data-test-selector'],
  clip: null,
  openRemoveModal: () => {},
  openReportModal: () => {},

  session: injectService(),
  userData: computed.readOnly('session.userData'),

  isMenuOpen: false,
  isLoggedIn: computed.bool('userData.login'),
  isAdmin: computed.or('userData.is_admin', 'userData.is_staff'),
  isBroadcaster: computed('clip.broadcasterID', 'userData.id', function () {
    const broadcasterID = this.get('clip.broadcasterID');
    const userID = this.get('userData.id');
    return (broadcasterID && userID) && (String(broadcasterID) === String(userID));
  }),
  isCurator: computed('clip.curatorID', 'userData.id', function () {
    const curatorID = this.get('clip.curatorID');
    const userID = this.get('userData.id');
    return (curatorID && userID) && (String(curatorID) === String(userID));
  }),
  canRemove: computed.or('isAdmin', 'isBroadcaster', 'isCurator'),
  shouldShowRemoveButton: computed.and('canRemove', 'isLoggedIn'),
  shouldShowReportButton: computed('isLoggedIn', 'canRemove', function () {
    return this.get('isLoggedIn') && !this.get('canRemove');
  }),

  init() {
    this._super(...arguments);
  },

  actions: {
    toggleMoreButton() {
      this.toggleProperty('isMenuOpen');
    },
    onShowRemoveModal() {
      this.get('openRemoveModal')();
    },
    onShowReportModal() {
      this.get('openReportModal')();
    }
  }
});
