import Component from 'ember-component';
import computed from 'ember-computed';
import { assert } from 'ember-metal/utils';
import {
  SORT_PERIOD_DAY,
  SORT_PERIOD_WEEK,
  SORT_PERIOD_MONTH,
  SORT_PERIOD_ALL,
  SORT_TRENDING
} from 'web-client/adapters/clip';

const OPTION_TO_TRANSLATION_KEY = {
  [SORT_TRENDING]: 'channel.clips.filter.trending',
  [SORT_PERIOD_DAY]: 'channel.clips.filter.top24h',
  [SORT_PERIOD_WEEK]: 'channel.clips.filter.top7d',
  [SORT_PERIOD_MONTH]: 'channel.clips.filter.top30d',
  [SORT_PERIOD_ALL]: 'channel.clips.filter.topAll'
};

export const TEST_SELECTOR = 'clips-sort-option';

const ClipsSortOption = Component.extend({
  tagName: 'a', // Styles are weird if we use 'button'
  classNames: ['balloon__link'],
  classNameBindings: ['isActiveSortOption:filter-bar__balloon-link--active'],
  testSelector: TEST_SELECTOR,
  attributeBindings: ['testSelector:data-test-selector'],

  sortOption: SORT_PERIOD_DAY,
  isActiveSortOption: false,
  onClick() {},

  init() {
    this._super(...arguments);

    assert(`${this} expects argument "sortOption"`, !!this.get('sortOption'));
  },

  click() {
    if (!this.get('isActiveSortOption')) {
      this.get('onClick')(this.get('sortOption'));
    }
  },

  noTimePill: computed.equal('sortOption', SORT_TRENDING),

  sortOptionTranslationKey: computed('sortOption', function() {
    return OPTION_TO_TRANSLATION_KEY[this.get('sortOption')];
  })
});

ClipsSortOption.reopenClass({
  positionalParams: ['sortOption']
});

export default ClipsSortOption;
