/* globals Twitch */
import { htmlSafe } from 'ember-string';
import Component from 'ember-component';
import computed from 'ember-computed';
import injectService from 'ember-service/inject';
import $ from 'jquery';
import { CREATIVE } from 'web-client/utilities/game-names';

export default Component.extend({
  tagName: 'span',

  tmi: injectService(),
  tracking: injectService(),

  button_toggle_count: 0,

  trackData(event) {
    this.get('tracking').trackEvent({
      event,
      data: {
        login: Twitch.user.login(),
        channel: this.get('channel.name'),
        button_toggle_count: this.button_toggle_count
      }
    });
  },

  showCommissionButton: computed('channel.creative.commission_button', function () {
    return this.get('channel.game') === CREATIVE && !!this.get('channel.creative.commission_button');
  }),

  commissionTextHtml: computed('channel.creative.commission_text_html', function () {
    let text = this.get('channel.creative.commission_text_html');
    return htmlSafe(text);
  }),

  actions: {
    toggle_commission_modal() {
      if (!Twitch.user.isLoggedIn()) {
        $.login({mpSourceAction: 'commission-button'});
      } else {
        $('#commission_modal').toggle();
        this.button_toggle_count++;
        this.trackData('commission_modal_toggle');
      }
    },

    start_commission_whisper() {
      this.get('tmi').sendWhisper(this.get('channel.name'), `Hey ${this.get('channel.name')}, I want to commission something from you!`);
      $('#commission_modal').hide();
      this.trackData('commission_start_whisper');
    }
  }
});
