import Component from 'ember-component';
import computed from 'ember-computed';
import { assert } from 'ember-metal/utils';

const DIRECTIONS = ['up', 'down', 'left', 'right'];
const SIZES = ['xs', 'sm', 'md', 'lg', 'xl', 'full'];

export default Component.extend({
  attributeBindings: [
    'testSelector:data-test-selector'
  ],
  classNames: ['balloon'],
  classNameBindings: [
    'balloonDirection',
    'balloonDropMenu',
    'balloonSize',
    'balloonNoTail',
    'padding',
    'balloonShow',
    'hide'
  ],

  /**
   * direction accepts a csv value:
   * I.E. 'up,right'
   */
  direction: 'down',
  isDropMenu: false,
  padding: 'pd-x-1',
  size: 'sm',
  show: null,
  testSelector: null,

  didReceiveAttrs(attributes) {
    this._super(...arguments);
    let { newAttrs } = attributes;

    if (newAttrs.direction && newAttrs.direction.value) {
      let directions = newAttrs.direction.value.split(',');

      directions.forEach((direction) => {
        assert(
          `${this} expects 'direction' to be a sub-set of ${DIRECTIONS}, got ${directions}`,
          DIRECTIONS.indexOf(direction) !== -1
        );
      });
    }
    assert(
      `${this} expects 'size' to be one of ${SIZES}`,
      !newAttrs.size || !newAttrs.size.value || SIZES.indexOf(newAttrs.size.value) !== -1
    );
  },

  balloonDirection: computed('direction', function() {
    let directions = this.get('direction').split(',');
    let classes = directions.map((direction) => `balloon--${direction}`);
    return classes.join(' ');
  }),

  balloonDropMenu: computed('isDropMenu', function() {
    let isDropMenu = this.get('isDropMenu');
    return isDropMenu ? 'balloon--dropmenu' : '';
  }),

  balloonNoTail: computed('isDropMenu', function() {
    let isDropMenu = this.get('isDropMenu');
    return isDropMenu ? 'balloon--no-tail' : '';
  }),

  balloonSize: computed('size', function() {
    return `balloon--${this.get('size')}`;
  }),

  balloonShow: computed('show', function() {
    let show = this.get('show');
    if (typeof show !== 'boolean') {
      return '';
    }

    return show ? 'show' : 'hide';
  })
});
