import Component from 'ember-component';
import computed from 'ember-computed';

export default Component.extend({
  type: 'button',
  tagName: 'button',
  classNames: ['button'],
  classNameBindings: [
    'isBalloonWrapper:balloon-wrapper',
    'isDisabled:button--disabled',
    'isHollow:button--hollow',
    'isDropMenu:button--dropmenu',
    'isText:button--text',
    'isFullWidth:full-width',
    'hasIcon:button--icon',
    'iconOnly:button--icon-only',
    'buttonSizeClassName'
  ],
  attributeBindings: [
    'isDisabled:disabled',
    'testSelector:data-test-selector',
    'ariaLabel:aria-label',
    'type'
  ],

  isBalloonWrapper: false,
  isDisabled: false,
  isHollow: false,
  isDropMenu: false,
  isText: false,
  isFullWidth: false,
  hasIcon: false,
  iconOnly: false,
  size: '',
  testSelector: null,
  ariaLabel: null,

  buttonSizeClassName: computed('size', function() {
    let size = this.get('size');
    if (size === 'large' || size === 'small') {
        return `button--${size}`;
    }

    return '';
  }),

  onClick() {},

  click() {
    this.get('onClick')();
  }
});
