import Component from 'ember-component';
import { assert } from 'ember-metal/utils';
import computed from 'ember-computed';

const IMAGE_OPTIONS = ['vod', 'avatar', 'sidekick'];
const BASE_IMAGE_CLASS = 'card__img';

/**
 * Implements the "Card Row" pattern:
 * https://git-aws.internal.justin.tv/pages/web/styles/ui/components/cards.html#row-modifiers
 *
 * You can provide your own custom card body like so if the standard title/info
 * fields aren't enough:
 * {{common/card-row imageSrc=imageSrc}}
 *   <div>Foo</div>
 * {{/common/card-row}}
 */
export default Component.extend({
  classNames: ['card', 'card--row'],
  classNameBindings: ['isSmall:card--sm'],
  attributeBindings: [
    'testSelector:data-test-selector'
  ],

  imageAlt: '',
  imageOptions: '',
  imageType: '',
  info: '',
  isSmall: false,
  testSelector: null,
  title: '',

  cardImageClass: computed('imageOptions', function() {
    let imageOptions = this.get('imageOptions').split(',');
    if (imageOptions[0] === '') {
      return `${BASE_IMAGE_CLASS}`;
    }

    return imageOptions.reduce((imageClass, option) => {
      assert(
        `${this} expects image settings to be a subset of ${IMAGE_OPTIONS}, got ${imageOptions}`,
        IMAGE_OPTIONS.indexOf(option) !== -1
      );
      return `${imageClass} ${BASE_IMAGE_CLASS}--${option}`;
    }, BASE_IMAGE_CLASS);
  })
});
