import Component from 'ember-component';
import computed from 'ember-computed';
import { TTV_BOXART_404_URL } from 'web-client/utilities/urls/static-cdn';
import InteractivityDeferredComponent from 'web-client/mixins/interactivity-deferred-component';
import { scheduleOnce } from 'ember-runloop';

export default Component.extend(InteractivityDeferredComponent, {
  didInsertElement() {
    this._super(...arguments);
    scheduleOnce('afterRender', this, this.reportInteractive);
  },

  community: null,
  thumbnail: computed('community.avatar_image_url', function () {
    return this.get('community.avatar_image_url') || TTV_BOXART_404_URL;
  }),
  highlightText: null
});
