import Component from 'ember-component';
import computed from 'ember-computed';
import { BASE_URL } from 'web-client/utilities/urls/communities';

// TODO: Migrate to App Setting
const OVERWATCH_ENTRIES = [
  '3dherocity',
  'AchlysNero',
  'Adufresne99',
  'ArrTeaSea',
  'ArtofMrDicks',
  'Arwenthesilent',
  'Avaltor05',
  'BanzaiBaby',
  'BlossomingSun',
  'BobWulff',
  'BrittanyStorm',
  'Browncoatcaptn',
  'CaptSugarSpice',
  'ChipWhitehouse',
  'Cullen9',
  'DandLee',
  'DarnisArt',
  'Draskia',
  'DrawnbyJill',
  'ELFinSOX',
  'Emanuelpants',
  'Eri_Saeko',
  'Eternity_Waits',
  'FadyLace',
  'Failgaming103',
  'FancySchmancyTV',
  'Fenori',
  'FrozenEcho',
  'GageZiegman',
  'GamerKirei',
  'GandaKris',
  'GlassManCometh',
  'Halie_Atisuto',
  'HentaiRobot',
  'HungryDoughnut',
  'HvitStag',
  'Infamous1080p',
  'IronMariel',
  'JUANTRIX00',
  'Jacobtm92',
  'JamesOrtegaArt',
  'JayHobo',
  'JennyGeeBerry',
  'Journeyman1029',
  'Joxol',
  'Juliehaze',
  'JustJ2Jay',
  'JustSketching',
  'KalaSketch',
  'Kanason',
  'Katernub',
  'Katykabooom',
  'Kisekii',
  'Kruzadar',
  'Kuspert',
  'LDBEAN',
  'Lara_Cr',
  'LeSallyChat',
  'LosGee',
  'Manacloud',
  'Mankej_',
  'MerryContrerry',
  'Mete0ryt',
  'MirajaneTV',
  'MizzyCyn',
  'Monicandy',
  'MrCreeep',
  'MurdokXcom',
  'Nerdfruit',
  'Newfoundgames',
  'Niku_Senpai',
  'NotADrugDealingTwitch',
  'Overwatchcontestwinner',
  'Pixelated_Takkun',
  'PyroferusRC',
  'QuirkiliciousLIVE',
  'RabbitKun',
  'RexDoesArt',
  'RileyOMalley',
  'RissaRambles',
  'Rn1K',
  'Sabtastique',
  'ShannonVanPelt',
  'ShraderDesigns',
  'SilverSeraph',
  'Songiesworld',
  'StronkGamer',
  'Suchikuchi',
  'ThatFakeGamerGirl',
  'TheNoosh22',
  'TigerSkullKola',
  'Wild4Games',
  'XDark_AlchemistX',
  'Yourbestfrieend',
  'YumiMyNinja',
  'allmybases',
  'amsbtt',
  'banzchan',
  'bunmira',
  'contraplexart',
  'destohfaeda',
  'doomkittenplays',
  'farmvilleguy',
  'gorogregoro',
  'gryphonburger',
  'highsight',
  'hirowbp',
  'hyperrpg',
  'ilianagatto',
  'jesiiiiika',
  'karikatures',
  'kaypikefashion',
  'khookcreations',
  'lazesummerstone',
  'madderhatter',
  'makohouse',
  'missingminds',
  'missmissa',
  'nikki_bruises',
  'ohnips',
  'outstarwalker',
  'r0_1_7',
  'r1sh',
  'routantan',
  'samwhiteart',
  'smabee_art',
  'sohlol',
  'soursprite',
  'spectre_dave',
  'staceyofgotham',
  'superballsHMC',
  'theladymea',
  'tokimonster',
  'wander_ex',
  'workingchef',
  'xASHLERx',
  'xephos49',
  'yelenaivy',
  'z_bot_'
];

const OVERWATCH_WINNERS = ['ohnips', 'Niku_Senpai', 'QuirkiliciousLIVE', 'CaptSugarSpice', 'Joxol'];

export default Component.extend({
  channels: null,
  winners: null,
  entries: computed('channels.[]', function () {
    let winners = this.get('winners');
    let defaultSort = winners.length + 1;
    return this.get('channels').map(channel => {
      let place = (winners.indexOf(channel) + 1) || null;
      return { channel, image: this.entryURL(channel), place };
    })
      // Sort by winners position, then alphabetical for the rest
      .sort((a, b) => {
        if (!a.place && !b.place) {
          return a.channel - b.channel;
        }
        return (a.place || defaultSort) - (b.place || defaultSort);
      });
  }),

  init() {
    this._super(...arguments);
    if (!this.get('channels')) {
      this.set('channels', OVERWATCH_ENTRIES);
    }
    if (!this.get('winners')) {
      this.set('winners', OVERWATCH_WINNERS);
    }
  },

  entryURL(channel) {
    return `${BASE_URL}/overwatchcontent/cropped/${channel}.jpg`;
  }
});
