import Component from 'ember-component';
import Ember from 'ember';

const { inject} = Ember;

/*
 * {{component-outlet 'outlet-name' sourceTemplateName='channels/new'}}
 *
 * Creates a component outlet for use with renderComponentOutlet
 * render a component into a {{component-outlet}} component. Often you
 * will want to use this near an outlet with the same name. For example:
 *
 * {{outlet 'left'}}
 * {{component-outlet 'left' sourceTemplateName='application'}}
 *
 *
 * For more information see app/ext/patch-route-render.js
 */
const ComponentOutletComponent = Component.extend({
  tagName: '',
  componentOutlet: inject.service(),
  willRender() {
    if (!this.get('sourceTemplateName')) {
      throw new Error('A sourceTemplateName must be provided to {{component-outlet}}');
    }
    if (!this.get('outletName')) {
      throw new Error('A param of the outlet name must be provided to {{component-outlet}}');
    }
  }
});

ComponentOutletComponent.reopenClass({
  positionalParams: ['outletName']
});

export default ComponentOutletComponent;
