import Component from 'ember-component';
import set from 'ember-metal/set';

const REASONS = [
  {value: 'not_interested', description: "Not Interested", checked: true},
  {value: 'offensive', description: "This content is offensive", checked: false},
  {value: 'other', description: "Other", checked: false}
];
const minTextDescription = 6;

export default Component.extend({
  reasons: REASONS,
  selectedReason: 'not_interested',
  textReasons: "",
  isDescriptionTooShort: false,

  _selectReason(value) {
    let reasons = this.get('reasons');
    reasons.map((reason) => {
      let checked = reason.value === value ? true : false;
      set(reason, 'checked', checked);
    });
    this.set('selectedReason', value);
    this.set('reasons', reasons);
  },

  actions: {
    selectReason(value) {
      this._selectReason(value);
    },
    submitFeedback(textDescription, selectedReason) {
      if (selectedReason === 'other' && textDescription.length < minTextDescription) {
        this.set('isDescriptionTooShort', true);
      } else {
        this.sendAction('submitFeedback', ...arguments);
        this._selectReason('not_interested');
      }
    },
    closeModal() {
      this._selectReason('not_interested');
      this.set('isDescriptionTooShort', false);
      this.sendAction('closeModal', ...arguments);
    }
  }
});
