/*
6/20/2016 - Brian Chan - bcnchan
Component that wraps the dashboard live components with a widget box
*/

import Component from 'ember-component';
import computed from 'ember-computed';
import run from 'ember-runloop';

let ANIM_DURATION = 250,
    ANIM_EASING = 'easeInOutSine';

export default Component.extend({
  /* passed in properties */
  title: null,
  noPad: null,
  hasSettings: null,
  fullCol: null,
  isCollapsed: false,
  saveConfig: null,
  isShowingWidgetSettings: false,

  /* internal properties */
  isNotFullCol: computed.not('fullCol'),
  isFullAndCollapsed: computed.and('fullCol', 'isCollapsed'),
  isNotFullAndCollapsed: computed('fullCol', 'isCollapsed', function () {
    return !this.get('fullCol') && this.get('isCollapsed');
  }),

  classNames: ['flex__item', 'js-live-widget', 'js-live-widget-wrapper'],
  classNameBindings: [
    'isNotFullCol:dash-widget-wrapper',
    'isNotFullCol:flex__item--noGrow',
    'fullCol:dash-widget-full-wrapper',
    'isNotFullAndCollapsed:dash-widget-wrapper--collapsed',
    'isFullAndCollapsed:dash-widget-full-wrapper',
    'isFullAndCollapsed:dash-widget-full-wrapper--collapsed'
  ],

  didInsertElement() {
    this._super(...arguments);

    if (this.get('isCollapsed')) {
      this.$('.js-live-widget__body').velocity('slideUp', {
        duration: ANIM_DURATION,
        easing: ANIM_EASING
      });
    }
  },

  actions: {
    collapseWidget() {
      run.throttle(this, '_throttleCollapseWidget', ANIM_DURATION);
    }
  },

  _throttleCollapseWidget() {
    let saveConfig = this.get('saveConfig');
    let slideDirection = this.get('isCollapsed') ? 'slideDown' : 'slideUp';

    this.$('.js-live-widget__body').velocity(slideDirection, {
      duration: ANIM_DURATION,
      easing: ANIM_EASING,
      complete: run.bind(this, () => {
        if (this.isDestroyed) { return; }

        saveConfig(this.$('.js-live-widget'));
      })
    });

    this.toggleProperty('isCollapsed');
  }
});
