import Component from 'ember-component';
import computed from 'ember-computed';
import injectController from 'web-client/utilities/inject-controller';
import injectService from 'ember-service/inject';

export default Component.extend({
  classNames: ['dash-chat', 'chat-container', 'js-chat-container', 'js-dashboard-chat-module'],
  classNameBindings: ['isDarkMode'],

  chatController: injectController('chat'),
  chatSettings: injectService(),

  /* Passed in properties */
  channel: null,
  isCollapsed: null,

  init() {
    this._super(...arguments);
    let chatController = this.get('chatController');
    chatController.setCurrentChannelRoom(this.get('channel.id'));
  },

  willDestroy() {
    this._super(...arguments);
    let chatController = this.get('chatController');
    chatController.removeCurrentChannelRoom();
  },

  isDarkMode: computed('chatSettings.darkMode', function () {
    return this.get('chatSettings.darkMode') ? 'dark theme--dark' : '';
  })
});
