import Component from 'ember-component';
import injectService from 'ember-service/inject';

export default Component.extend({
  autohost: injectService(),
  store: injectService(),
  tracking: injectService(),

  classNames: ['js-host-details', 'card', 'card--sm', 'card--row'],
  classNameBindings: [
    'added:autohost-card--inlist'
  ],

  channel: null,
  host: null,

  added: false,
  shouldShowAutohostAdd: true,
  isAutohost: false,

  actions: {
    addToList() {
      let autohost = this.get('autohost');
      let hostChannel = this.get('host');
      let channel = this.get('channel');

      this.get('tracking').trackEvent({
        event: 'autohost_channel_update',
        data: {
          time: Date.now(),
          source: this.get('trackingSource'),
          location: 'dashboard',
          login: channel.get('name'),
          target_channel: hostChannel.get('name'),
          action: 'added'
        }
      });

      return autohost.addChannelToList(hostChannel.get('_id'));
    },

    removeFromList() {
      let autohost = this.get('autohost');
      let hostChannel = this.get('host');
      let channel = this.get('channel');

      this.get('tracking').trackEvent({
        event: 'autohost_channel_update',
        data: {
          time: Date.now(),
          source: this.get('trackingSource'),
          location: 'dashboard',
          login: channel.get('name'),
          target_channel: hostChannel.get('name'),
          action: 'removed'
        }
      });

      return autohost.removeChannelFromList(hostChannel.get('_id'));
    }
  }
});
