
import Component from 'ember-component';
import injectService from 'ember-service/inject';

export default Component.extend({
  autohost: injectService(),

  /* passed in properties */
  channel: null,
  hosts: null,
  isChannelOwner: null,
  trackingSource: null,
  emptyMessage: null,
  trackDashboardEvent() {},

  /* internal properties */
  isShowingAll: false,

  actions: {
    toggleShowingAll() {
      if (!this.get('isShowingAll')) {
        let trackDashboardEvent = this.get('trackDashboardEvent');

        trackDashboardEvent('live_dashboard_host', {
          action: 'click',
          target_name: 'all_hosts'
        });
      }

      this.toggleProperty('isShowingAll');
    }
  }
});
