import Component from 'ember-component';
import injectService from 'ember-service/inject';

export default Component.extend({
  autohost: injectService(),
  session: injectService(),

  channel: null,
  isChannelOwner: false,

  actions: {
    snooze() {
      let autohost = this.get('autohost');
      let channel = this.get('channel');

      return autohost.snooze(channel.get('_id'));
    },

    unsnooze() {
      let autohost = this.get('autohost');
      let channel = this.get('channel');

      return autohost.unsnooze(channel.get('_id'));
    }
  }
});
